// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : intro.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "Extro.h"
#include "input.h"
#include "Application.h"



Extro::Extro() :
  m_Level( NULL )
{

  closeIntro = false;
  clickLeft  = false;

  m_Level.Load( 13 );

  m_ExtroText.push_back( "Well Done!" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "You have debugged and defeated the" );
  m_ExtroText.push_back( "mastermind behind the bug infestion." );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "Thank you for playing this game!" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "I hope you enjoyed it!" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "Big Thanks go to Dr. Dobb's Journal and" );
  m_ExtroText.push_back( "Microsoft Visual Studio 2008" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "Both made this game possible." );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "Good Graphics: Dr. Dobb's Journal" );
  m_ExtroText.push_back( "Bad Graphics: Myself" );
  m_ExtroText.push_back( "Sound Effects: DrPetters Sound Tool" );
  m_ExtroText.push_back( "Speech: Cepstral Text-To-Speech" );
  m_ExtroText.push_back( "Code and Bugs: Myself" );
  m_ExtroText.push_back( "Level Design: Myself" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "" );
  m_ExtroText.push_back( "Can you find the secret room?" );

  m_TextPos = 0.0f;

  for ( int i = 0; i < 6; ++i )
  {
    m_SoundStarted[i] = false;
  }

}



Extro::~Extro() 
{

  g_App.StopSound( "Extro.1" );
  g_App.StopSound( "Extro.2" );
  g_App.StopSound( "Extro.3" );
  g_App.StopSound( "Extro.4" );
  g_App.StopSound( "Extro.5" );
  g_App.StopSound( "Extro.6" );

}



void Extro::UpdateTimed( const float ElapsedTime )
{

  m_Level.UpdateTimed( ElapsedTime );

  m_TextPos += 30.0f * ElapsedTime;

  if ( ( m_TextPos >= 120.0f )
  &&   ( !m_SoundStarted[0] ) )
  {
    m_SoundStarted[0] = true;
    g_App.PlaySound( "Extro.1" );
  }
  if ( ( m_TextPos >= 270.0f )
  &&   ( !m_SoundStarted[1] ) )
  {
    m_SoundStarted[1] = true;
    g_App.PlaySound( "Extro.2" );
  }
  if ( ( m_TextPos >= 450.0f )
  &&   ( !m_SoundStarted[2] ) )
  {
    m_SoundStarted[2] = true;
    g_App.PlaySound( "Extro.3" );
  }
  if ( ( m_TextPos >= 650.0f )
  &&   ( !m_SoundStarted[3] ) )
  {
    m_SoundStarted[3] = true;
    g_App.PlaySound( "Extro.4" );
  }
  if ( ( m_TextPos >= 910.0f )
  &&   ( !m_SoundStarted[4] ) )
  {
    m_SoundStarted[4] = true;
    g_App.PlaySound( "Extro.5" );
  }
  if ( ( m_TextPos >= 1480.0f )
  &&   ( !m_SoundStarted[5] ) )
  {
    m_SoundStarted[5] = true;
    g_App.PlaySound( "Extro.6" );
  }

}



void Extro::Update() 
{

  m_Level.Update();

  if ( ( g_App.m_Input.KeyPressed( VK_SPACE ) )
  ||   ( g_App.m_Input.KeyPressed( VK_ESCAPE ) ) )
  {
    g_App.ChangeGameState( new Menu() );
    return;
  }

  if ( g_App.m_Input.MouseButtonDown( 1 ) ) 
  {
    clickLeft = true; 
  } 
  else 
  {
    if ( clickLeft )
    {
      g_App.ChangeGameState( new Menu() );
      return;
    }
  }

}



void Extro::Render()
{

  m_Level.Render( 0xffffffff );

  for ( size_t i = 0; i < m_ExtroText.size(); ++i )
  {
    int   Y = 630 + i * 40 - (int)m_TextPos;

    if ( ( Y >= -50 )
    &&   ( Y < 600 ) )
    {
      g_App.RenderTextCentered( "Extro", m_ExtroText[i], 401, Y + 1, 0xff000000 );
      g_App.RenderTextCentered( "Extro", m_ExtroText[i], 400, Y );
    }
  }

}